<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Admin only routes
Route::middleware(['auth', 'admin'])->group(function () {
    Route::resource('users', UserController::class);
});

// Invoicing routes (for authenticated users only)
Route::middleware('auth')->group(function () {
    Route::get('/invoicing', [App\Http\Controllers\InvoicingController::class, 'index'])->name('invoicing.index');
    Route::post('/invoicing/submit', [App\Http\Controllers\InvoicingController::class, 'submitInvoice'])->name('invoicing.submit');
    Route::post('/invoicing/validate', [App\Http\Controllers\InvoicingController::class, 'validateInvoice'])->name('invoicing.validate');

    // FBR API endpoints for reference data
    Route::get('/api/fbr/provinces', [App\Http\Controllers\InvoicingController::class, 'getProvinceCodes'])->name('api.fbr.provinces');
    Route::get('/api/fbr/hs-codes', [App\Http\Controllers\InvoicingController::class, 'getHsCodes'])->name('api.fbr.hs-codes');
    Route::get('/api/fbr/item-description-codes', [App\Http\Controllers\InvoicingController::class, 'getItemDescriptionCodes'])->name('api.fbr.item-description-codes');
    Route::get('/api/fbr/uom', [App\Http\Controllers\InvoicingController::class, 'getUnitsOfMeasurement'])->name('api.fbr.uom');
    Route::get('/api/fbr/transaction-types', [App\Http\Controllers\InvoicingController::class, 'getTransactionTypeCodes'])->name('api.fbr.transaction-types');
    Route::get('/api/fbr/tax-rates', [App\Http\Controllers\InvoicingController::class, 'getTaxRates'])->name('api.fbr.tax-rates');
    Route::post('/api/fbr/registration-type', [App\Http\Controllers\InvoicingController::class, 'getRegistrationType'])->name('api.fbr.registration-type');
    Route::post('/api/fbr/sale-type-to-rate', [App\Http\Controllers\InvoicingController::class, 'getSaleTypeToRate'])->name('api.fbr.sale-type-to-rate');
});

require __DIR__.'/auth.php';
